/*
 * FMS database interaction routines
 */

#include <stdio.h>
#include <sys/time.h>

#include "db.h"

#include "libfma.h"
#include "lf_scheduler.h"

#include "fms.h"
#include "fms_error.h"
#include "fms_db.h"

/*
 * Get the database fired up
 */
int
init_database()
{
  /* Open the database */
  F.database = db_open_database(F.fms_run, F.db_name, 1);
  if (F.database == NULL) LF_ERROR(("Opening database"));
  return 0;

 except:
  return -1;
}

/*
 * close database
 */
void
close_database()
{
  db_close_database(F.database);
}
